using System;
using System.Data;
using System.Data.SqlClient;
using Sprocs = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/21/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing read access to the business rules 
	///	data stored in a database.
	///</summary>
	
	public class BrokenRules
	{
		private const string BrokenRuleSetSearchTemplate = "FormName='{0}' and RuleSet='{1}'";
		private static DataTable _brokenRuleSetsCache;

		private BrokenRules() {}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/6/2004</CreationDate>
		///<TestCases>
		///<Case type="0" testid ="430"> 
		///		<ExpectedInput>Form/class and rule set name.</ExpectedInput>
		///		<ExpectedOutput>Non-empty array of DataRow objects containing broken rules data.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4858"> 
		///		<ExpectedInput>Null as form name.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4859"> 
		///		<ExpectedInput>Null as rule set.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads all broken rules for the given form/class and a rule set.
		/// </summary>
		/// <param name="formName">VBECS form/class name.</param>
		/// <param name="ruleSet">Rule set name.</param>
		/// <returns><see cref="DataTable"/> containing list of a broken rules for a given form/class and rule set.</returns>
		public static DataRow[] GetBrokenRules( string formName, string ruleSet )
		{
			if( formName == null )
				throw( new ArgumentNullException( "formName" ) );

			if( ruleSet == null )
				throw( new ArgumentNullException( "ruleSet" ) );

			VerifyCache();

			return _brokenRuleSetsCache.Select( String.Format( BrokenRuleSetSearchTemplate, formName, ruleSet ) );
		}

		/// <summary>
		/// Makes sure all VBECS broken rule sets are loaded into cache. If not - performs load. 
		/// </summary>
		private static void VerifyCache()
		{
			if( _brokenRuleSetsCache != null )
				return;

			lock( typeof( BrokenRules ) )
			{
				if( _brokenRuleSetsCache != null )
					return;
				
				_brokenRuleSetsCache = Common.StoredProcedure.GetDataTable( Sprocs.GetAllBrokenRuleSets.StoredProcName );

				foreach( DataColumn _col in _brokenRuleSetsCache.Columns )
					_col.ReadOnly = true;
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/7/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4856"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Non-empty DataTable containing broken rules.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4857"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves all broken rules validation messages from the VBECS database.
		/// </summary>
		/// <returns><see cref="DataTable"/> containing validation messages for all broken rules.</returns>
		public static DataTable GetBrokenRulesValidationMessages()
		{
			return Common.StoredProcedure.GetDataTable( Sprocs.GetBrokenRulesValidationMessages.StoredProcName );
		}
	}
}
